@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.menuMultum.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.menu-multa.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label class="required" for="placa">{{ trans('cruds.menuMultum.fields.placa') }}</label>
                <input class="form-control {{ $errors->has('placa') ? 'is-invalid' : '' }}" type="text" name="placa" id="placa" value="{{ old('placa', '') }}" required>
                @if($errors->has('placa'))
                    <span class="text-danger">{{ $errors->first('placa') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.placa_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="auto">{{ trans('cruds.menuMultum.fields.auto') }}</label>
                <input class="form-control {{ $errors->has('auto') ? 'is-invalid' : '' }}" type="text" name="auto" id="auto" value="{{ old('auto', '') }}" required>
                @if($errors->has('auto'))
                    <span class="text-danger">{{ $errors->first('auto') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.auto_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="infracao">{{ trans('cruds.menuMultum.fields.infracao') }}</label>
                <input class="form-control {{ $errors->has('infracao') ? 'is-invalid' : '' }}" type="text" name="infracao" id="infracao" value="{{ old('infracao', '') }}">
                @if($errors->has('infracao'))
                    <span class="text-danger">{{ $errors->first('infracao') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.infracao_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="orgao_competente">{{ trans('cruds.menuMultum.fields.orgao_competente') }}</label>
                <input class="form-control {{ $errors->has('orgao_competente') ? 'is-invalid' : '' }}" type="text" name="orgao_competente" id="orgao_competente" value="{{ old('orgao_competente', '') }}">
                @if($errors->has('orgao_competente'))
                    <span class="text-danger">{{ $errors->first('orgao_competente') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.orgao_competente_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="local">{{ trans('cruds.menuMultum.fields.local') }}</label>
                <input class="form-control {{ $errors->has('local') ? 'is-invalid' : '' }}" type="text" name="local" id="local" value="{{ old('local', '') }}">
                @if($errors->has('local'))
                    <span class="text-danger">{{ $errors->first('local') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.local_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="condutor_id">{{ trans('cruds.menuMultum.fields.condutor') }}</label>
                <select class="form-control select2 {{ $errors->has('condutor') ? 'is-invalid' : '' }}" name="condutor_id" id="condutor_id">
                    @foreach($condutors as $id => $entry)
                        <option value="{{ $id }}" {{ old('condutor_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('condutor'))
                    <span class="text-danger">{{ $errors->first('condutor') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.condutor_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="situacao">{{ trans('cruds.menuMultum.fields.situacao') }}</label>
                <input class="form-control {{ $errors->has('situacao') ? 'is-invalid' : '' }}" type="text" name="situacao" id="situacao" value="{{ old('situacao', '') }}" required>
                @if($errors->has('situacao'))
                    <span class="text-danger">{{ $errors->first('situacao') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.situacao_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="data_infracao">{{ trans('cruds.menuMultum.fields.data_infracao') }}</label>
                <input class="form-control date {{ $errors->has('data_infracao') ? 'is-invalid' : '' }}" type="text" name="data_infracao" id="data_infracao" value="{{ old('data_infracao') }}" required>
                @if($errors->has('data_infracao'))
                    <span class="text-danger">{{ $errors->first('data_infracao') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.data_infracao_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="valor_total">{{ trans('cruds.menuMultum.fields.valor_total') }}</label>
                <input class="form-control {{ $errors->has('valor_total') ? 'is-invalid' : '' }}" type="number" name="valor_total" id="valor_total" value="{{ old('valor_total', '') }}" step="0.01">
                @if($errors->has('valor_total'))
                    <span class="text-danger">{{ $errors->first('valor_total') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.valor_total_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="vencimento_auto">{{ trans('cruds.menuMultum.fields.vencimento_auto') }}</label>
                <input class="form-control date {{ $errors->has('vencimento_auto') ? 'is-invalid' : '' }}" type="text" name="vencimento_auto" id="vencimento_auto" value="{{ old('vencimento_auto') }}">
                @if($errors->has('vencimento_auto'))
                    <span class="text-danger">{{ $errors->first('vencimento_auto') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.vencimento_auto_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.menuMultum.fields.infracao_autoriazada') }}</label>
                <select class="form-control {{ $errors->has('infracao_autoriazada') ? 'is-invalid' : '' }}" name="infracao_autoriazada" id="infracao_autoriazada">
                    <option value disabled {{ old('infracao_autoriazada', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\MenuMultum::INFRACAO_AUTORIAZADA_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('infracao_autoriazada', '1') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('infracao_autoriazada'))
                    <span class="text-danger">{{ $errors->first('infracao_autoriazada') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.infracao_autoriazada_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.menuMultum.fields.pagamento_disponivel') }}</label>
                <select class="form-control {{ $errors->has('pagamento_disponivel') ? 'is-invalid' : '' }}" name="pagamento_disponivel" id="pagamento_disponivel">
                    <option value disabled {{ old('pagamento_disponivel', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\MenuMultum::PAGAMENTO_DISPONIVEL_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('pagamento_disponivel', '1') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('pagamento_disponivel'))
                    <span class="text-danger">{{ $errors->first('pagamento_disponivel') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.pagamento_disponivel_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.menuMultum.fields.statuspagamento') }}</label>
                <select class="form-control {{ $errors->has('statuspagamento') ? 'is-invalid' : '' }}" name="statuspagamento" id="statuspagamento">
                    <option value disabled {{ old('statuspagamento', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\MenuMultum::STATUSPAGAMENTO_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('statuspagamento', '') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('statuspagamento'))
                    <span class="text-danger">{{ $errors->first('statuspagamento') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.statuspagamento_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.menuMultum.fields.gera_nic') }}</label>
                <select class="form-control {{ $errors->has('gera_nic') ? 'is-invalid' : '' }}" name="gera_nic" id="gera_nic">
                    <option value disabled {{ old('gera_nic', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\MenuMultum::GERA_NIC_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('gera_nic', '1') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('gera_nic'))
                    <span class="text-danger">{{ $errors->first('gera_nic') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.gera_nic_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="auto_gerador">{{ trans('cruds.menuMultum.fields.auto_gerador') }}</label>
                <input class="form-control {{ $errors->has('auto_gerador') ? 'is-invalid' : '' }}" type="text" name="auto_gerador" id="auto_gerador" value="{{ old('auto_gerador', '') }}">
                @if($errors->has('auto_gerador'))
                    <span class="text-danger">{{ $errors->first('auto_gerador') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.menuMultum.fields.auto_gerador_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection