<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Controllers\Traits\MediaUploadingTrait;
use App\Http\Requests\MassDestroyMeusveiculoRequest;
use App\Http\Requests\StoreMeusveiculoRequest;
use App\Http\Requests\UpdateMeusveiculoRequest;
use App\Models\Meusveiculo;
use App\Models\Team;
use Gate;
use Illuminate\Http\Request;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class MeusveiculosController extends Controller
{
    use MediaUploadingTrait, CsvImportTrait;

    public function index(Request $request)
    {
        abort_if(Gate::denies('meusveiculo_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = Meusveiculo::with(['team'])->select(sprintf('%s.*', (new Meusveiculo)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'meusveiculo_show';
                $editGate      = 'meusveiculo_edit';
                $deleteGate    = 'meusveiculo_delete';
                $crudRoutePart = 'meusveiculos';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('placa', function ($row) {
                return $row->placa ? $row->placa : '';
            });
            $table->editColumn('renavam', function ($row) {
                return $row->renavam ? $row->renavam : '';
            });
            $table->editColumn('chassi', function ($row) {
                return $row->chassi ? $row->chassi : '';
            });
            $table->editColumn('marca_modelo', function ($row) {
                return $row->marca_modelo ? $row->marca_modelo : '';
            });
            $table->editColumn('cor', function ($row) {
                return $row->cor ? $row->cor : '';
            });
            $table->editColumn('anomodelo', function ($row) {
                return $row->anomodelo ? $row->anomodelo : '';
            });
            $table->editColumn('status', function ($row) {
                return $row->status ? Meusveiculo::STATUS_SELECT[$row->status] : '';
            });
            $table->editColumn('empresa', function ($row) {
                return $row->empresa ? $row->empresa : '';
            });
            $table->editColumn('cpfcnpj', function ($row) {
                return $row->cpfcnpj ? $row->cpfcnpj : '';
            });
            $table->editColumn('setor', function ($row) {
                return $row->setor ? $row->setor : '';
            });
            $table->editColumn('seguradora', function ($row) {
                return $row->seguradora ? $row->seguradora : '';
            });
            $table->editColumn('tag', function ($row) {
                return $row->tag ? $row->tag : '';
            });

            $table->rawColumns(['actions', 'placeholder']);

            return $table->make(true);
        }

        $teams = Team::get();

        return view('admin.meusveiculos.index', compact('teams'));
    }

    public function create()
    {
        abort_if(Gate::denies('meusveiculo_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.meusveiculos.create');
    }

    public function store(StoreMeusveiculoRequest $request)
    {
        $meusveiculo = Meusveiculo::create($request->all());

        if ($media = $request->input('ck-media', false)) {
            Media::whereIn('id', $media)->update(['model_id' => $meusveiculo->id]);
        }

        return redirect()->route('admin.meusveiculos.index');
    }

    public function edit(Meusveiculo $meusveiculo)
    {
        abort_if(Gate::denies('meusveiculo_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meusveiculo->load('team');

        return view('admin.meusveiculos.edit', compact('meusveiculo'));
    }

    public function update(UpdateMeusveiculoRequest $request, Meusveiculo $meusveiculo)
    {
        $meusveiculo->update($request->all());

        return redirect()->route('admin.meusveiculos.index');
    }

    public function show(Meusveiculo $meusveiculo)
    {
        abort_if(Gate::denies('meusveiculo_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meusveiculo->load('team');

        return view('admin.meusveiculos.show', compact('meusveiculo'));
    }

    public function destroy(Meusveiculo $meusveiculo)
    {
        abort_if(Gate::denies('meusveiculo_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meusveiculo->delete();

        return back();
    }

    public function massDestroy(MassDestroyMeusveiculoRequest $request)
    {
        $meusveiculos = Meusveiculo::find(request('ids'));

        foreach ($meusveiculos as $meusveiculo) {
            $meusveiculo->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }

    public function storeCKEditorImages(Request $request)
    {
        abort_if(Gate::denies('meusveiculo_create') && Gate::denies('meusveiculo_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $model         = new Meusveiculo();
        $model->id     = $request->input('crud_id', 0);
        $model->exists = true;
        $media         = $model->addMediaFromRequest('upload')->toMediaCollection('ck-media');

        return response()->json(['id' => $media->id, 'url' => $media->getUrl()], Response::HTTP_CREATED);
    }
}
